import numpy as np
import matplotlib.pyplot as plt

### Very elementary, non-robust, implementation of the simple upwind method
### for u_t =- uu_{x} for x \in (-0.5,1.5) with "Dirichlet bc u(-0.5)=1,u(1.5)=0"

# define the spatial mesh: total number of mesh points 'H+1', spacing 'hstep'
L = 2
H = 5000
xstep = L/H
xres=np.linspace(-0.5,1.5,H+1)

# define the initial condition
u0=np.ones(len(xres))
for counter in range(len(xres)):
    if xres[counter]>0.0 and xres[counter]<1.0:
        u0[counter]=-xres[counter]+1.0
    elif xres[counter]>=1.0:
        u0[counter]=0.0
        
uj=u0

# define the time mesh, final time 'T' and stepsize 'tstep'
K=16000
T=1
tstep = T/K

# check whether the CFL condition is satisfied
print(tstep/xstep)

# define the vectors and matrices for the output
ures = np.zeros((H+1,K))
ures[:,0] = uj
tres = np.linspace(0,T,K)

# main loop/iteration to march the solution forward
for counter in range(len(tres)-1):
    ujshift = np.delete(np.insert(uj,0,1.0),-1)
    uj = uj + (tstep/(2.0*xstep))*(ujshift**2-uj**2)
    ures[:,counter+1] = uj

# plot the solution as time snapshots
plt.plot(xres, ures[:,0],color='k',linewidth=0.5)
plt.plot(xres, ures[:,int(np.floor(K/2))],color='k',linewidth=1.5)
plt.plot(xres, ures[:,K-1],color='k',linewidth=2.5)

# re-size a bit for saving it properly
figure = plt.gcf()
figure.set_size_inches(4, 2)
plt.savefig('fig03.eps', bbox_inches='tight')

plt.show()


