import numpy as np
import matplotlib.pyplot as plt

### Very elementary, non-robust, implementation of the finite-difference
### method for u_t =delta* u_{xx} + u(1-u)(u-p) for x \in (0,L) with zero Neumann bc

# define the spatial mesh: total number of mesh points 'H+1', spacing 'hstep'
L = 10
delta=0.001
H = 200
hstep = 1.0/H
xres=np.linspace(0,L,H+1)

# define the initial condition
u0=1/2*(np.tanh(xres-8)+1)
uj=u0

# define the time mesh, final time 'T' and stepsize 'tstep'
K=10**5
T=30.0
tstep = T/K

# define the vectors and matrices for the output
ures = np.zeros((H+1,K))
ures[:,0] = uj
tres = np.linspace(0,T,K)

# build the finite-difference discretization of the Laplacian
A=-2*np.eye(H+1)
for counter in range(0,H):
    A[counter,counter+1]=1.0
    A[counter+1,counter]=1.0
# take care of the boundary condition
A[0,1]=2.0
A[H,H-1]=2.0

# set the parameter p
p=0.15

# main loop/iteration to march the solution forward
for counter in range(len(tres)-1):
    uj = uj +  (delta*tstep/(hstep**2))*A.dot(uj) + tstep*uj*(1-uj)*(uj-p)
    ures[:,counter+1] = uj

# plot the solution as time snapshots
plt.plot(xres, ures[:,0],color='k',linewidth=0.5)
plt.plot(xres, ures[:,int(np.floor(K/2))],color='k',linewidth=1.5)
plt.plot(xres, ures[:,K-1],color='k',linewidth=2.5)

# re-size a bit for saving it properly
figure = plt.gcf()
figure.set_size_inches(4, 2)
plt.savefig('fig02.eps', bbox_inches='tight')

plt.show()


