import numpy as np
import matplotlib.pyplot as plt

### Very elementary, non-robust, implementation of the finite-difference
### method for u_t = u_{xx} + u(1-u) for x \in (0,1) with zero Neumann bc

# define the spatial mesh: total number of mesh points 'H+1', spacing 'hstep'
H = 50
hstep = 1/H
xres=np.linspace(0,1,H+1)

# define the initial condition
u0=np.sin(2*np.pi*xres)+0.8
uj=u0

# define the time mesh, final time 'T' and stepsize 'tstep'
K=30000
T=0.5
tstep = T/K

# define the vectors and matrices for the output
ures = np.zeros((H+1,K))
ures[:,0] = uj
tres = np.linspace(0,T,K)

# build the finite-difference discretization of the Laplacian
A=-2*np.eye(H+1)
for counter in range(0,H):
    A[counter,counter+1]=1.0
    A[counter+1,counter]=1.0
# take care of the boundary condition
A[0,1]=2.0
A[H,H-1]=2.0

# main loop/iteration to march the solution forward
for counter in range(len(tres)-1):
    uj = uj + tstep * ( (1/hstep**2)*A.dot(uj) + (uj-uj**2) )
    ures[:,counter+1] = uj

# plot the solution as time snapshots
plt.plot(xres, ures[:,0],color='k',linewidth=0.5)
plt.plot(xres, ures[:,int(np.floor(K/100))],color='k',linewidth=1)
plt.plot(xres, ures[:,int(np.floor(K/50))],color='k',linewidth=1.5)
plt.plot(xres, ures[:,int(np.floor(K/10))],color='k',linewidth=2)
plt.plot(xres, ures[:,K-1],color='k',linewidth=2.5)

# re-size a bit for saving it properly
figure = plt.gcf()
figure.set_size_inches(4, 2)
plt.savefig('fig01.eps', bbox_inches='tight')

plt.show()
